/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1999-2000 Parametric Technology Corporation.
	All rights reserved.
*/

#include "stdafx.h"
#include "AdpFuncs.h"
#include "CProdUtils.h"
extern IApplication *pdApp;
extern IHelm *pHelm;

//----------------------------------------------------------------------------------------------------------------------------------
namespace AdpExample {
using namespace ProDESKTOPLib;

HRESULT Bind(const CString& dispName, IReference **ref)
{
	HRESULT hr = S_OK;
	IBindCtx *pbc = NULL;
	ULONG chEaten = 0;
	IMoniker *pmkOut = NULL;
	IObject *obj = NULL;
	IDispatch *disp = NULL;
	*ref = NULL;

	if (FAILED(CreateBindCtx(0, &pbc)))
		return E_FAIL;

	USES_CONVERSION;
	hr = MkParseDisplayName(pbc, T2OLE(dispName), &chEaten, &pmkOut);
	if (FAILED(hr) || !pmkOut)
		return hr;

	if (pmkOut && SUCCEEDED(hr) ) {
		hr = pmkOut->BindToObject(pbc, NULL, IID_IReference, (void **)ref);
		ASSERT(ref);
	}
	return hr;
}

HRESULT CalculateTotalCurveLength(const CStringList& dispNameList, double& lengthSum)
{
	HRESULT hr = S_OK;
	POSITION pos = dispNameList.GetHeadPosition();
	IReference *ref = NULL;
	while (pos) {
		CString dispName = dispNameList.GetNext(pos);
		hr = Bind(dispName, &ref);
		if (!ref)
			continue;
		
		VARIANT_BOOL deleted = FALSE;
		LPOLESTR pszDisplayName;
		USES_CONVERSION;
		hr = ref->IsDeleted(&deleted);
		double lengthCurve = 0;

		if (!deleted) {

			hr = ref->GetDisplayName(&pszDisplayName);
			CString name = OLE2T(pszDisplayName);
			
			IDispatch *disp = NULL;
			hr = ref->GetObject(&disp);

			IObject *pObj = NULL;
			hr = disp->QueryInterface(IID_IObject, (void **)&pObj);
			
			IGeometric *pGeometric = NULL;
			hr = pObj->QueryInterface(IID_IGeometric, (void **)&pGeometric);

			IGeometry *pGeometry = NULL;
			hr = pGeometric->GetGeometricForm(&pGeometry);

			ICurve *pCur = NULL;
			hr = pGeometry->QueryInterface(IID_ICurve, (void **)&pCur);

			double chordalError = 0.1;
			IPolyline *pPolyLine = NULL;
			hr = pCur->GetPolylineEquivalent(chordalError, &pPolyLine);

			int numPoints = 0;
			hr = pPolyLine->GetPointCount(&numPoints);

			for (int i = 0; i < numPoints - 1; i++)
			{
				IVector *vector1 = NULL;
				IVector *vector2 = NULL;
				hr = pPolyLine->GetPoint(i, &vector1);
				hr = pPolyLine->GetPoint(i+1, &vector2);
				double lengthPolyLine = 0;
				vector1->GetDistanceFrom(vector2, &lengthPolyLine);
				lengthCurve = lengthCurve + lengthPolyLine;
			}

			hr = pPolyLine->Release();
			hr = pCur->Release();
			hr = pGeometry->Release();
			hr = pGeometric->Release();
			hr = pObj->Release();
		}
		lengthSum = lengthSum + lengthCurve;
		hr = ref->Release();
	}
	return hr;
}

HRESULT UpdateDisplayNameList(CStringList& dispNameList)
{
	HRESULT hr = S_OK;
	POSITION pos1;
	POSITION pos2;
	if (dispNameList.IsEmpty()) {
		AfxMessageBox("Sorry, No DisplayNames to update. Load or select lines.");
		return hr;
	}
	IReference *ref = NULL;
	for (pos1 = dispNameList.GetHeadPosition(); (pos2 = pos1) != NULL;) {
		CString dispName = dispNameList.GetNext(pos1);
		ref = NULL;
		hr = Bind(dispName, &ref);

		if (!ref)
			continue;

		VARIANT_BOOL changed = FALSE;
		VARIANT_BOOL deleted = FALSE;
		LPOLESTR pszDisplayName;
		USES_CONVERSION;

		hr = ref->IsDeleted(&deleted);
		if (deleted) {
			CString temp = dispNameList.GetAt(pos2);
			dispNameList.RemoveAt(pos2);
			continue;
		}

		hr = ref->IsChanged(&changed);
		if (changed) {
			hr = ref->UpdateComplete(&pszDisplayName);
			CString name = OLE2T(pszDisplayName);
			CString temp = dispNameList.GetAt(pos2);
			dispNameList.SetAt(pos2, name);
		}
	}
	return hr;
}

HRESULT HighlightChangedObjects(const CStringList& dispNameList)
{
	HRESULT hr = S_OK;
	POSITION pos = dispNameList.GetHeadPosition();
	IReference *ref = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument * activePart = NULL;
	bool fileNotOpened = FALSE;

	hr = RunProDESKTOP(&pdApp);
	if (FAILED(hr) || !pdApp)
		AfxMessageBox("Pro/DESKTOP could not be started");

	hr = pdApp->TakeHelm(&pHelm);
	if (FAILED(hr) || !pHelm)
		return E_FAIL;

	ISet *objSet = NULL;
	hr = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	while (pos) {
		CString dispName = dispNameList.GetNext(pos);
		ref = NULL;
		hr = Bind(dispName, &ref);

		if (!ref)
			continue;

		VARIANT_BOOL changed = FALSE;
		VARIANT_BOOL deleted = FALSE;
		USES_CONVERSION;

		hr = ref->IsDeleted(&deleted);
		if (deleted) 
			continue;

		hr = ref->IsChanged(&changed);
		if (changed) {
			IDispatch *disp = NULL;
			hr = ref->GetObject(&disp);
			IObject *obj = NULL;
			hr = disp->QueryInterface(IID_IObject, (void **)&obj);
			if (!fileNotOpened) {
				IFile *file = NULL;
				hr = obj->GetFile(&file);

				LPOLESTR name;
				hr = file->GetName(&name);

				CString fileName = OLE2T(name);
				
				hr = pdApp->OpenPart(fileName.AllocSysString(), &activePart);
				if (SUCCEEDED(hr) && activePart)
					fileNotOpened = TRUE;

				hr = pdApp->GetActiveDoc(&activeGraphicDoc);
			}
			hr = objSet->AddMember(obj);
		}
	}
	if (objSet) {
		long numChangedObject = 0;
		hr = objSet->GetCount(&numChangedObject);
		if (numChangedObject) {
			hr = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
			CString str = "Operation";
			hr = pHelm->CommitCalls(str.AllocSysString(), FALSE);
		}
	}
	hr = pHelm->Release();
	return hr;
}

HRESULT HighlightObjects(const CStringList& dispNameList)
{
	HRESULT hr = S_OK;
	POSITION pos = dispNameList.GetHeadPosition();
	IReference *ref = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument * activePart = NULL;
	bool fileNotOpened = FALSE;

	hr = RunProDESKTOP(&pdApp);
	if (FAILED(hr) || !pdApp)
		AfxMessageBox("Pro/DESKTOP could not be started");

	hr = pdApp->TakeHelm(&pHelm);
	if (FAILED(hr) || !pHelm)
		return E_FAIL;

	ISet *objSet = NULL;
	hr = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	while (pos) {
		CString dispName = dispNameList.GetNext(pos);
		ref = NULL;
		hr = Bind(dispName, &ref);
		if (!ref)
			continue;
		
		VARIANT_BOOL deleted = FALSE;
		USES_CONVERSION;

		hr = ref->IsDeleted(&deleted);
		if (deleted) 
			continue;

		IDispatch *disp = NULL;
		hr = ref->GetObject(&disp);
		IObject *obj = NULL;
		hr = disp->QueryInterface(IID_IObject, (void **)&obj);
		if (!fileNotOpened) {
			IFile *file = NULL;
			hr = obj->GetFile(&file);

			LPOLESTR name;
			hr = file->GetName(&name);

			CString fileName = OLE2T(name);
			
			hr = pdApp->OpenPart(fileName.AllocSysString(), &activePart);
			if (SUCCEEDED(hr) && activePart)
				fileNotOpened = TRUE;

			hr = pdApp->GetActiveDoc(&activeGraphicDoc);
		}
		hr = objSet->AddMember(obj);
	}
	if (objSet) {
		long numObject = 0;
		hr = objSet->GetCount(&numObject);
		if (numObject) {
			hr = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
			CString str = "Operation";
			hr = pHelm->CommitCalls(str.AllocSysString(), FALSE);
		}
	}
	hr = pHelm->Release();
	return hr;
}

HRESULT ConstructDisplayNameListForSelectedLines(CStringList& dispNameList)
{
	HRESULT hr = S_OK;

	hr = RunProDESKTOP(&pdApp);
	if (FAILED(hr) || !pdApp)
		AfxMessageBox("Pro/DESKTOP could not be started");

	IGraphicDocument *activeGraphicDoc = NULL;
	IObject *pObj = NULL;
	IDispatch *disp = NULL;
	IReference *ref = NULL;
	LPOLESTR pszDisplayName = 0;

	hr = pdApp->TakeHelm(&pHelm);

	CString str2 = "Open Design";
	hr = pdApp->GetActiveDoc(&activeGraphicDoc);

	if (activeGraphicDoc)
		hr = pHelm->CommitCalls(str2.AllocSysString(), TRUE);
	else {
		while (FAILED(hr) || !activeGraphicDoc) {
			AfxMessageBox("Open a Design.");
			hr = pHelm->CommitCalls(str2.AllocSysString(), TRUE);
			hr = pdApp->GetActiveDoc(&activeGraphicDoc);
		}
	}
	
	while (!IsFileSaved(activeGraphicDoc)) {
		AfxMessageBox("Design must be saved.Please save and try again.");
		hr = pHelm->CommitCalls(str2.AllocSysString(), TRUE);
	}
	
	ISet *objectSet = NULL;
	hr = activeGraphicDoc->GetSelection(L"Graphic", &objectSet);

	IIt *it = NULL;
	hr = (GetCLASS(It))->CreateAObjectIt(objectSet, &it);

	VARIANT_BOOL tmpBool = TRUE;
	hr = it->start(&disp);
	hr = it->IsActive(&tmpBool);
	while (SUCCEEDED(hr) && tmpBool) {

		pObj = NULL;
		ref = NULL;
		hr = it->Current(&disp);
		IObject2 *pObject2 = NULL;
		hr = disp->QueryInterface(IID_IObject2, (void **)&pObject2);
		
		hr = pObject2->GetReference(&disp);
		hr = disp->QueryInterface(IID_IReference, (void **) &ref);
		hr = ref->GetDisplayName(&pszDisplayName);
		
		USES_CONVERSION;
		CString name = OLE2T(pszDisplayName);
		dispNameList.AddTail(name);
		disp->Release();
		ref->Release();
		hr = pObject2->Release();
		hr = it->Next(&disp);
		hr = it->IsActive(&tmpBool);
	}
	long numOfLinesSelected = dispNameList.GetCount();
	if (0 == numOfLinesSelected)
		AfxMessageBox("Warning : No Selections Made. Display Name List will be empty.");
	CString str = "Operation";
	hr = pHelm->CommitCalls(str.AllocSysString(), FALSE);
	pHelm->Release();
	return hr;
}

//----------------------------------------------------------------------------------------------------------------------------------
}	// namespace AdpExample
